<?php
/* --------------------------------------------------------------
   DeletedSingleWithdrawal.php 2020-03-30
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\Events;

use Gambio\Admin\Withdrawal\Interfaces\WithdrawalId;

/**
 * Class DeletedSingleWithdrawal
 *
 * @package Gambio\Admin\Withdrawal\Events
 */
class DeletedSingleWithdrawal
{
    /**
     * @var WithdrawalId
     */
    private $withdrawalId;
    
    
    /**
     * DeletedSingleWithdrawalEvent constructor.
     *
     * @param WithdrawalId $withdrawalId
     */
    private function __construct(WithdrawalId $withdrawalId)
    {
        $this->withdrawalId = $withdrawalId;
    }
    
    
    /**
     * @param WithdrawalId $withdrawalId
     *
     * @return DeletedSingleWithdrawal
     */
    public static function create(WithdrawalId $withdrawalId): DeletedSingleWithdrawal
    {
        return new self($withdrawalId);
    }
    
    
    /**
     * @return WithdrawalId
     */
    public function withdrawalId(): WithdrawalId
    {
        return $this->withdrawalId;
    }
}